/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.dialog;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.uicontrols.security.IVWRecipientSelectionPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWRecipientComboPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWRecipientFilterPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class VWReassignItemDialog
extends VWModalDialog
implements ActionListener {
    protected int m_returnValue = -1;
    protected Frame m_parentFrame = null;
    protected VWSession m_vwSession = null;
    protected JTextArea m_instructionsField = null;
    protected JCheckBox m_approveCheckBox = null;
    protected IVWRecipientSelectionPanel m_recipientSelectionPanel = null;
    protected JButton m_okButton = null;
    protected JButton m_cancelButton = null;
    protected JButton m_helpButton = null;

    public VWReassignItemDialog(Frame parentFrame, VWSession session, boolean allowDelegate) {
        super(parentFrame);
        this.m_parentFrame = parentFrame;
        this.m_vwSession = session;
        Dimension dim = VWStringUtils.stringToDimension("445,165");
        if (dim == null) {
            dim = new Dimension(400, 150);
        }
        try {
            if (this.m_vwSession.getSecurityDatabaseType() == 1) {
                dim.setSize(dim.width, dim.height * 2);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.setSize(dim);
        this.setVisible(false);
        this.setTitle(VWResource.s_reassignAssignment);
        this.createControls(allowDelegate);
    }

    public boolean getDelegateFlag() {
        if (this.m_approveCheckBox != null) {
            return this.m_approveCheckBox.isSelected();
        }
        return false;
    }

    public String getInstructions() {
        if (this.m_instructionsField != null) {
            return this.m_instructionsField.getText();
        }
        return null;
    }

    public VWParticipant getSelectedItem() {
        if (this.m_recipientSelectionPanel != null && this.m_recipientSelectionPanel.hasValidSelection()) {
            return this.m_recipientSelectionPanel.getSelectedValue();
        }
        return null;
    }

    public int getValue() {
        return this.m_returnValue;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_cancelButton) {
            this.m_returnValue = 2;
            this.setVisible(false);
        } else if (object == this.m_okButton) {
            if (this.getSelectedItem() == null) {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_noRecipientSelected, 1);
                return;
            }
            this.m_returnValue = 0;
            this.setVisible(false);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_General + "bpfsp013.htm");
        }
    }

    private void createControls(boolean allowDelegate) {
        try {
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.fill = 0;
            gbCons.insets = new Insets(4, 4, 4, 4);
            gbCons.ipadx = 0;
            gbCons.ipady = 0;
            this.getContentPane().add((Component)new JLabel(VWResource.s_selectAParticipantColon), gbCons);
            ++gbCons.gridy;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.fill = 1;
            this.m_recipientSelectionPanel = this.m_vwSession.getSecurityDatabaseType() == 1 ? new VWRecipientFilterPanel(this, this.m_vwSession) : new VWRecipientComboPanel(this, this.m_vwSession);
            this.getContentPane().add((Component)((JPanel)((Object)this.m_recipientSelectionPanel)), gbCons);
            ++gbCons.gridy;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.fill = 2;
            this.m_approveCheckBox = new JCheckBox(VWResource.s_delegateWork);
            this.m_approveCheckBox.setEnabled(allowDelegate);
            this.getContentPane().add((Component)this.m_approveCheckBox, gbCons);
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(1, 4, 4));
            panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.m_okButton = new JButton(VWResource.s_ok);
            panel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            panel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_helpDots);
            panel.add(this.m_helpButton);
            ++gbCons.gridy;
            this.getContentPane().add((Component)panel, gbCons);
            this.m_okButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

